<?php
include 'setup.php';
header('Content-Type: application/json');

if ($_SERVER['REQUEST_METHOD'] === 'GET') {
    $posId = $_GET['PosId'] ?? null;
} else {
    $input = json_decode(file_get_contents("php://input"), true);
    $posId = $input["PosId"] ?? null;
    
}

if (!$posId) {
    http_response_code(400);
    echo json_encode(["error" => "PosId is required"]);
    exit;
}



// Query to get all records where PosId matches
$stmt = $conn->prepare("SELECT * FROM AllRecords WHERE PosId = ? AND TableName = 'User'");
$stmt->bind_param("s", $posId);
$stmt->execute();
$result = $stmt->get_result();


// Process results
$data = null;


while ($row = $result->fetch_assoc()) {
   

        $data = $row["Last_date"];
        echo json_encode(["ExpDate" => $data]);
        break;
    
}

$stmt->close();
$conn->close();



?>
